/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

// annoyances-overlays

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

const genericSelectorMap = [[1811,"#Bloque_EX_Newsletter"],[2675,"#Bloque_EX_NewsletterTematico"],[3800,"#EmailOptin"],[2593,"#FlyoutSignupModalWrapper"],[2715,"#FooterNewsletter"],[2326,"#GlobalSlotHeaderNewsletter"],[3619,"#HPNewsletter,\n.e-newsletter"],[124,"#NNSubscribeBar"],[2701,"#NewsletterOverlay,\n.foo-newsletter,\n.yikes-mailchimp-container"],[1501,"#NewsletterSignUpSidebar,\n.newsletter-form__wrapper--inbodyContent"],[2855,"#NewsletterSticky_pnlNewsletterSticky"],[2686,"#NewsletterSubscribe,\n#footerSubscribe"],[3995,"#PopupSignupForm_0"],[3988,"#RColNewslatter,\n.inlineNewsletterSignup"],[3932,"#SideNewsletterBox"],[1425,"#Subscribe-Article-Bottom"],[2321,"#SubscribePopUpBox"],[2819,"#SubscribePushNotificationPanel,\n.drawer__header-container.is-moved-by-drawer"],[2136,"#Widget-Newsletter"],[3820,"#ajax-newsletter-form"],[1865,"#alertNewsletter"],[3192,"#app_newsletter"],[3494,"#article-newsletter-signup"],[102,"#article-newsletter-slot"],[1270,"#article-promo-newsletter"],[2251,"#barNewsletter"],[1561,"#bloc-newsletter"],[1387,"#bloc_newsletter"],[3626,"#block-dfp-subscriptions-block,\n#newsletters-1-form-wrapper"],[1013,"#block-mailchimp-signup-newsletter"],[3557,"#block-newsletteraside,\n#email-exitintent-widget"],[2922,"#block-newsletteroverlay"],[3580,"#block-newsletterpopup"],[4069,"#block-quick-subscribe-footer"],[1061,"#block-sailthru-basic-newsletter"],[345,"#block-sailthru-newsletters"],[1900,"#bottom_newsletter"],[641,"#boxNewsletter"],[1064,"#boxes-box-newsletter,\n#sidebar-newsletter"],[303,"#cm-popup-overlay"],[1335,"#collapse-newsletter"],[35,"#collapse-newsletter-trigger"],[1313,"#divNewsletterPromoPopup"],[2798,"#divnewslettertipo_1"],[2797,"#divnewslettertipo_2"],[2087,"#e2ma_signup_form"],[2328,"#email-alerts-button,\n#nl-fixed-bottom,\n.newsletter-introtext"],[2690,"#email-display-trigger"],[779,"#email-footer,\n.footer-newsletter-section"],[3371,"#email-marketing-widget"],[2882,"#email-modal-bg"],[306,"#email-news-subscribe"],[1706,"#email-opt-in-bottom"],[2026,"#email-popup-back"],[3012,"#email-posts-to-subscribers-2"],[121,"#email-rotator-wrapper,\n#nm-subscribe-wrapper,\n.followit--follow-form-container"],[494,"#email-signup-sidebar,\n#newsletter-signup-footer,\n#newsletter_signup_footer"],[1314,"#email-widget-wrapper,\n.widget_mailchimpsf_widget"],[2134,"#engagement-newsletter,\n.ue-c-article__newsletter-widget"],[575,"#exit-overlay-inline,\n.bg-newsletter-signup"],[4081,"#floating_subscribe"],[2295,"#footer-newsletter-mobile"],[1198,"#footer-newsletter-signup"],[2402,"#footer-newsletter-subscribe"],[630,"#footer-subscription-modal"],[2427,"#footerNewsletter"],[2663,"#footer__newsletter-signup"],[2238,"#footer_block_newsletter,\n#sailthru-basic-newsletter-form,\n.newsletterPlacement,\n.widget_woo_customsubscribewidget"],[3356,"#footer_newsletter_signup"],[2670,"#form-footer-newsletters"],[1683,"#form-newsletter-footer,\n.blog_subscription,\n.newsletter-article-footer,\n.optin-monster"],[2588,"#fusion-email-signup-modal"],[2498,"#gastro-email-roadblock-modal"],[3423,"#gigya-newsletter-social"],[1445,"#gnt_atomsnc,\n.essb-subscribe-form-content"],[966,"#id_newsletter_subscription,\n.home-subscribe-col"],[531,"#id_newsletter_subscription_popup"],[578,"#injected-newsletter"],[889,"#injector-signup"],[2017,"#inline-subscribe-form"],[1147,"#inscription_newsletter,\n.btn_big_newsletter"],[2748,"#instream_newsletter_signup,\n#kanews-modal-adblock"],[1884,"#iscrizione_newsletter"],[1027,"#js-mobile-subscribe-bar,\n.tds-newsletter"],[868,"#js-newslettermodal"],[3428,"#js-overlayEmailSignup"],[2703,"#js-subscription-box"],[3688,"#leaflet-newsletter-form,\n#signup_right_sidebar"],[2989,"#left-footer-subscribe"],[1167,"#left-newsletters-form,\n.c-subscribe-newsletter-banner"],[2034,"#leftcol_subscribe"],[2255,"#leftnewslettersubsblock"],[813,"#list-newsletter-form"],[486,"#m-inline-newsletter"],[2118,"#mailchimp-top-bar,\ndiv.bloc_newsletter"],[1507,"#mailing-list-popup"],[2213,"#mailing-list-signup,\n#sidebar-email-subscription"],[2825,"#mc-frontpage-subscribe,\n.gmg-subscribe-widget"],[1745,"#mc-signup-in-post"],[594,"#mc_embed_signup_nojs"],[722,"#misty-newsletter-subscribe"],[278,"#ml-newsletterform"],[1673,"#mm_newsletter"],[601,"#mobileNewsletterInput"],[3411,"#mod-newsletter-1"],[3379,"#mod-newsletter-signup-1,\n#mod-newsletter-signup-2"],[37,"#modale_inscription_newsletter"],[3762,"#new-nl-placeholder"],[479,"#new_newsletter_subscription"],[2944,"#newsLetterFooterDiv,\n#newsletterFooterDiv"],[3635,"#newsLetterWidgetSection"],[2403,"#newsletter-ad"],[3307,"#newsletter-alert-signup"],[3134,"#newsletter-background,\n.c-newsletter-form,\n.getresponse-signup-container"],[3565,"#newsletter-banner"],[2930,"#newsletter-banner-bottom"],[3632,"#newsletter-below-post,\n#newsletter-inline-widget"],[687,"#newsletter-bottom-bar"],[2596,"#newsletter-callout"],[2832,"#newsletter-cta"],[764,"#newsletter-exit-modal"],[1070,"#newsletter-flag,\n.c-call--newsletter"],[84,"#newsletter-floating"],[3363,"#newsletter-footer"],[2001,"#newsletter-form-footer"],[762,"#newsletter-incentive,\n.newslettergf_wrapper"],[3337,"#newsletter-inline"],[2619,"#newsletter-interstitial"],[3088,"#newsletter-overlay"],[3375,"#newsletter-pop-in"],[1052,"#newsletter-popin"],[1820,"#newsletter-popup-fixed"],[1189,"#newsletter-popup-overlay,\n#newsletter_popup_overlay,\n#slice-container-newsletterForm-exitIntent"],[677,"#newsletter-promo"],[968,"#newsletter-rail,\n.pane-mailchimp-signup-newsletter"],[3682,"#newsletter-roadblock,\n.newsletter-content-page"],[2996,"#newsletter-shortcode"],[506,"#newsletter-side-widget"],[2337,"#newsletter-sidebar"],[952,"#newsletter-signup-overlay,\n.Sailthru_Subscribe"],[456,"#newsletter-signup-short-form"],[978,"#newsletter-signup-sidebar"],[3720,"#newsletter-single-step"],[1266,"#newsletter-slide"],[3702,"#newsletter-slideout"],[3392,"#newsletter-slider"],[999,"#newsletter-strip"],[1367,"#newsletter-subscribe-sidebar"],[1655,"#newsletter-subscription-popup"],[3689,"#newsletter-teaser"],[2171,"#newsletterFooter"],[1460,"#newsletterLBContainer"],[3693,"#newsletterOverlay"],[1192,"#newsletterOverlayBg"],[458,"#newsletterPush"],[953,"#newsletterPush-overlay,\n.newsletter-shortcode"],[3660,"#newsletterSidebar"],[2822,"#newsletterSidebarBox"],[994,"#newsletterStickyBanner,\n.moduletable_newsletterform"],[3381,"#newsletter_form_3div"],[1859,"#newsletter_info_container"],[3308,"#newsletter_middle"],[313,"#newsletter_mod"],[2098,"#newsletter_popup"],[3311,"#newsletter_ribbon"],[2665,"#newsletter_sidebar_form,\n.single-post-newsletter"],[2006,"#newsletter_signup_ft"],[3598,"#newsletter_signup_fullwidth"],[68,"#newsletter_signup_side,\n.newsletter-bottom"],[1088,"#newsletter_smartbar"],[1941,"#newsletter_sub_form"],[247,"#newsletter_subscription_footer"],[629,"#newsletter_widget-2"],[2090,"#newsletterad"],[985,"#newsletterflyin"],[1140,"#newsletters-1-form"],[983,"#newsletters-2-form"],[1916,"#newsletters-footer-content"],[2384,"#newsletters-signup-sidebar"],[3899,"#newsletters_rdr"],[3581,"#nlSliderSignup"],[2142,"#nl_popin"],[3419,"#nl_signup_rr"],[1212,"#nlpopupmask"],[3780,"#nm-subscribe-box"],[1698,"#node-basic-newsletter"],[3284,"#node-email-widget,\n.popin-newsletter"],[2381,"#noti_wrap"],[1609,"#notification-subscribe-newsletter"],[1616,"#onesignal-popover-container"],[122,"#overlayPopinNewsletter"],[1493,"#piano-article-newsletter,\ndiv#newsletter_signup_article"],[2577,"#piano-newsletter-inline"],[393,"#pnlFooterNewsletterSignup"],[439,"#popinNewsletter"],[2281,"#popupNewsletter"],[2523,"#popup_newslettter"],[228,"#pp-subscribe"],[1551,"#rail-newsletter"],[3784,"#rhs_newsletter"],[3234,"#rr-newsletter-signup"],[4054,"#rr_newsletter,\n.newsLettetPb"],[1331,"#sailthru-email-form-wrapper,\n.nl-newsletter_signup"],[2866,"#sailthru-newsletters-email-form-wrapper"],[2378,"#sailthru-subscribe-sidebar"],[3053,"#sdac_subscribe_widget-3"],[3113,"#sendpress_signup,\n.widget-newsletter-sign-up__form"],[672,"#share-newsletter"],[3680,"#sib_embed_signup"],[3748,"#side-newsletter-signup,\n.widget_newsletters"],[1746,"#sidebar-block-newsletters"],[1022,"#sidebar-email-widget"],[2770,"#sidebar-newsletter-form,\n.newsletter-signup-home"],[2773,"#sidebar-newsletter-signup"],[2264,"#sidebar-newsletter-wrapper"],[2495,"#signup-inline-newsletter"],[2445,"#signup_interstitial,\n.component-newsletter-signup"],[201,"#signup_interstitial_overlay"],[1199,"#sleek-subscribe,\n.nl-subscription-inarticle"],[4032,"#slice-container-newsletterForm-articleInbodyContent"],[3352,"#ssnewsletter"],[1346,"#sssubscribe-wrapper,\n.newsletter-form-wrap"],[3722,"#subNewsletter"],[249,"#subNewsletterV1"],[4074,"#subscribe-block-bottom"],[2728,"#subscribe-box-mobile"],[4028,"#subscribe-popin"],[1531,"#subscribe-widget,\n.newsletters-subscribe-form-ajax"],[1248,"#subscribe-widget-bottom"],[3148,"#subscribe-widget-top"],[1605,"#subscribeCTA"],[3465,"#subscribePopup,\n#subscribepopup"],[3346,"#subscribePopupform"],[2081,"#subscribeRect"],[2032,"#subscribe_form_fixed"],[763,"#subscribe_modal_container"],[817,"#subscribe_overlay_container"],[4002,"#subscribe_popup"],[3639,"#subscribe_widget-3"],[2000,"#ta_newsletter,\n.newsletter_home"],[2303,"#tab_newsletter"],[3190,"#taboola-newsletter"],[2846,"#td-box-newsletter,\n.c-newsletter-widget"],[1073,"#td-newsletter-home"],[3054,"#td-sailthru-form"],[911,"#teaser-newsletter,\n.signup-form--footer"],[2039,"#uglipop_content_fixed"],[1738,"#uglipop_overlay"],[3965,"#ui-join-newsletter"],[1723,"#v-subscribe-article-form"],[1565,"#v-subscribe-short-form"],[2892,"#widget-newsletter-signup"],[1857,"#widgetNewsletter"],[1539,"#wp-subscribe"],[2707,"#wp_newsletter"],[307,".BannerNewsletter"],[1836,".BoxNewsletter"],[2050,".CampaignType--popup.exit-intent,\n.form-newsletter-content"],[887,".GRDC_newsletters"],[172,".Homepage-newsletter,\n.subscribe_footer"],[2122,".MultiColorSubscribeWidget"],[1608,".NewsLetterLeftSide,\n.bs-subscribe-newsletter"],[2141,".Newsletter-Overlay"],[729,".Newsletter-shortcode,\n.js-tealium-newsletter"],[3539,".NewsletterBanner"],[2666,".NewsletterBox--footer"],[2852,".NewsletterSignupInset,\n.newsletter-wide"],[3937,".NewsletterWidget--style-full-width"],[945,".StageNewsletterSimple"],[2438,"._newsletterContentPromo"],[3495,".a-newsletter"],[3834,".actions-newsletter"],[382,".alo_easymail_widget"],[861,".area-newsletter"],[718,".article-block--newsletter,\n.c-popular__collection--newsletter"],[586,".article-bottom-newsletter"],[2806,".article-bottom-newsletter_box,\n.footernewsletter"],[3992,".article-chimp-subscribe"],[2052,".article-footer-newsletter,\n.article_footer_newsletter,\n.b-email-subscribe-form"],[3395,".article-footer__subscribe"],[3227,".article-gutter-signup"],[2302,".article-news-letter,\n.smartmag-widget-newsletter"],[3832,".article-newsletter-module,\n.news-article__newsletter"],[3898,".article-newsletter-subscription"],[3622,".article-newsletter-wrapper,\n.ot-subscribe-widget"],[1312,".article-sidebar-newsletter,\n.newsletter.cta,\n.newsletter.widget"],[410,".article-signup-widget"],[412,".article-signup_wrapper"],[7,".article-slidein-newsletter"],[2274,".article-subscribe-container"],[281,".article-subscription-widget"],[1703,".article-tile-newsletter,\n.comp-newsletter-newslettersignup"],[440,".article_footer_subscribe"],[3627,".article_newsletter_signup,\ndiv.article-newsletter-signup"],[80,".article_page_right_subscribe"],[1419,".articles-newsletter"],[1611,".aside-common-subscribe,\n.newsletterban"],[44,".aside-little_newsletter"],[280,".aside-subscribe-module,\n.cont_popup_suscripicion_boletin_load"],[904,".at_nwletters"],[906,".at_subscribe"],[89,".b-email-popup"],[1457,".b-email-popup-backdrop"],[466,".b-email-subscribe-drawer"],[2237,".b-footer-subscribe,\n.c25__newsletter"],[3396,".b-newsletter"],[2314,".b-newsletter-modal"],[1592,".b-newsletter-signup"],[2007,".b-post-subscription"],[1106,".bNewsletter,\n.c-newsletterSticky"],[1449,".banner-newsletter"],[1243,".banner_newsletter,\n.newsletter-signup2"],[3316,".bar_newsletter,\n.popinNewsletter-overlay"],[1529,".bb-newsletter"],[2680,".bd-subscribe-wrapper"],[2373,".bk-section-subscribe"],[1019,".bk-subscribe-email"],[1002,".bk-subscribe-popup"],[2699,".bl_newsletter"],[367,".bloc-info-newsletter"],[2932,".bloc-newsletter,\ndiv.bloc-newsletter"],[1415,".bloc-recup-email"],[783,".blocSubscribeRight"],[1946,".block--newsletter--alt"],[1168,".block--newsletter-signup"],[137,".block-content-newsletter,\n.giga-email-subscribe"],[3927,".block-email-alerts-footer"],[2187,".block-mailchimp-signup"],[927,".block-newsletter-signup,\n.newsletter__slidein"],[1624,".block-social-newsletter"],[588,".block-sp-frontpage-newsletter"],[2492,".block_newsletter,\n.news_letter_signup"],[187,".blog-signup-container,\n.newsletter-sticky"],[2366,".blog_signup_box"],[3929,".body-subscribtion-box"],[3253,".bottom_signup_newsletter"],[2318,".bottom_subscribe"],[2659,".box--newsletter"],[2921,".box-iscrizione-newsletter"],[3213,".box-newsletter-article"],[3669,".box-newsletter-category"],[2692,".bs-newsletter-pack"],[3385,".btmNewsletter"],[2025,".btn-newsletter-head"],[3278,".bx-teaser-container--newsletter"],[1950,".c-Footer__subscribe"],[1840,".c-articleNewsletter_form"],[3282,".c-cta--newsletter"],[3353,".c-list-subscribe"],[815,".c-native-newsletterbox"],[3128,".c-newsletter--cta,\n.newsletterSubscribeContainer"],[184,".c-newsletter--default"],[2947,".c-newsletter--footer,\n.newsletter-lightbox,\n.newsletter_signup_footer"],[1426,".c-newsletter-article__content,\n.iscriviti-newsletter"],[2642,".c-newsletter-banner"],[3199,".c-newsletter-context,\n.cta-subscribe"],[1574,".c-newsletter-form__inner"],[32,".c-newsletter-promo"],[3077,".c-newsletter-section"],[2873,".c-newsletter-signup"],[3070,".c-newsletter-subscribe"],[1747,".c-newsletterSubscribe_form,\n.newsletterSubscribe"],[2201,".c-popular__newsletter"],[2990,".c-post-actions__newsletter"],[370,".c-promo-box--newsletter"],[1321,".c-reengageNewsletter"],[3841,".c-touchpoint-newsletters"],[3055,".c-widget--newsletter"],[2734,".callout--subscribe"],[4062,".captation-email-bottom"],[3590,".card--newsletter"],[264,".card-newsletter"],[2008,".card-newsletter-signup,\n.newsletterSignup-wrapper"],[391,".chunk-newsletter"],[3786,".cm_newsletter,\n.mailchimp-lists-user-subscribe-form"],[1685,".cmg_signup_box"],[3130,".column--newsletter"],[1107,".column-newsletter"],[3271,".column-subscribe"],[1634,".component-emailsubscription"],[3321,".component-newsletter-cta"],[759,".component-newsletter-subscribe"],[2580,".cont-newsletter"],[2060,".cont-newsletter-header"],[2343,".container-form-newsletter"],[3115,".container_newsletter"],[1282,".container_row--newsletter"],[2367,".contains-newsletter"],[3237,".content--newsletter,\n.optin-monster-api"],[3852,".content-c__newsletter--box"],[1751,".content-mod-newsletter-right"],[2287,".content-subscribe-block,\n.ha-c-newsletter-promo"],[2745,".content-toaster--newsletter"],[1221,".content-well-newsletter"],[3203,".cta__item--newsletter"],[2442,".daily-news-letter"],[2350,".daily-newsletter"],[2405,".daily_email_signup"],[3196,".divFooterEmailSignUp"],[3161,".divSubscrbtionBox"],[3544,".duet--cta--newsletter"],[4070,".e-newsletter-block"],[3997,".e-newsletter-block__initial"],[1666,".e-newsletter-block_footer"],[1995,".e-newsletter-overlay"],[2123,".e-newsletter-wrapper"],[1311,".e-newsletter_modal,\n.newsletter-stickybar"],[1909,".ebm-subscribe,\n.edm-subscribe"],[2541,".email-cta,\n.hasNewsletter"],[1007,".email-subscription-div"],[1272,".email-subscription-promo,\n.widget-email-cta"],[1233,".email-subscription-sidebar,\n.momizat-news_letter"],[1145,".email-subscription-wrap"],[3772,".email-widget-container"],[2280,".emailSubscribeBox"],[2911,".email_podpis-wrapper"],[1048,".email_subscribe__container"],[511,".email_subscribe_box,\n.newsletter-dropin"],[2533,".email_subscribe_container"],[897,".encart-newsletter,\n.newsletterFloating,\n.newsletter_email"],[3309,".endpage_newsletter_signup"],[2023,".enews-widget"],[3236,".enews-wrapper"],[1829,".entry-footer-subscribe,\n.newsletter-signup--homepage"],[2322,".entry-newsletter"],[1948,".entryNewsletter,\n.mtbn-newsletter-bar"],[2981,".eoa__newsletter-signup,\n.subscribe-box-wrapper"],[707,".et_bloom_flyin"],[104,".et_newsletter_widget"],[706,".et_pb_newsletter:not(.et_pb_login)"],[3520,".f-newsletter"],[1201,".featured_newsletter"],[3214,".fixed-overlay-subscription,\n.modal-suggest-newsletter-pro,\n.newsletter-optin"],[74,".fixed_newslettor,\n.newsletter-social,\n.newsletter_social"],[266,".flexible-content--newsletter"],[2631,".float-newsletter-bar"],[3963,".floating-newsletter-container"],[3643,".flyout-newsletter-rr,\n.widget-newsletter-wrap-2"],[3697,".flyover-email-cta"],[2449,".follow-embed__newsletter"],[1952,".follow-subscribe"],[3294,".footer--newsletter"],[2312,".footer-banner-newsletter"],[701,".footer-col-subscribe"],[3246,".footer-email-signup-container"],[109,".footer-n__newsletter"],[895,".footer-nav-newsletters"],[819,".footer-newslatter"],[695,".footer-newsletter"],[2417,".footer-newsletter-box"],[2416,".footer-newsletter-cta"],[2043,".footer-newsletter-form,\n.newsletter_info"],[2243,".footer-newsletter-signup,\n.o-site-footer__newsletter"],[2244,".footer-newsletter-social"],[981,".footer-newsletter-wrapper"],[1716,".footer-newsletters"],[2579,".footer-sign-up"],[27,".footer-sign-up-form"],[1973,".footer-signup"],[2284,".footer-social-email"],[3071,".footer-subscrabe-box"],[1279,".footer-subscribe-widget"],[1324,".footer__newsletter"],[1046,".footer__newsletter-form"],[1414,".footer__subscribe"],[2835,".footer_box_newsletter"],[4092,".footer_form_newsletter"],[3269,".footer_newsletter"],[1883,".footer_subscribe"],[1363,".footer_subscription_block,\n.adblock-whitelist-messaging__article-wrapper"],[3425,".footeremail"],[363,".form-newsletter-container"],[1042,".form-signup-articlebottom"],[882,".form__newsletter-subscribe"],[3825,".form__newsletter-subscribe--block"],[1091,".formkit-slide-in"],[2959,".ft_newsletter"],[633,".ftr-nwsltr"],[919,".fuzoBox--newsletter"],[1339,".gdm-newsletter-banner__container"],[3127,".getresponse-signup"],[1150,".gh-subscribe"],[3909,".gigyaNewsletterSignup"],[963,".gk-amp-newsletter"],[3453,".global-article-newsletter"],[1511,".global-nav__subscribe-toggle"],[1748,".global-newsletter-sign-up"],[3940,".gnt_m_nls"],[3726,".h-newsletter"],[3850,".h-register-newsletter"],[851,".h-subscribe"],[334,".h-teaser-newsletter,\n.widget_woo_subscribe"],[492,".ha-c-newsletter-promo__content"],[3182,".head-email-signup"],[751,".header-newsletter-box,\n.tg-newsletter,\n.ts-newsletter"],[3342,".headerNewsletterCtaOverlay"],[626,".header__newsletter"],[1777,".hellobar-signup"],[1999,".hero-sidebar-newsletter"],[3900,".home-newsletter,\n.subscription_popup__wrapper"],[1765,".home-newsletter-container"],[3285,".home-newsletter-widget"],[616,".home-subscribe__signup-form"],[801,".homeNewsletter"],[1050,".homeSubscribeCTAContainer"],[2333,".homepage-bottom-email-signup,\n.widget-subscribe_widget"],[460,".homepage-newsletter"],[1345,".hs-subscribe-form-wrap"],[3630,".hypelab-newsletter,\n.type-newsletter-signup"],[1668,".ibnewsletter-embedded"],[3957,".ibnewsletter-popup"],[1351,".ibnewsletter-wrapper"],[1675,".ifklicked-subscribe"],[3279,".ifklicked-subscribe-form"],[1947,".ifklicked-subscribe-form-below"],[1443,".in-article-newsletter-form"],[356,".inarticle-newsletter-widget"],[291,".incontent-newsletter"],[3853,".ing-newsletter-box"],[3466,".inline-email-signup-container"],[1355,".inline-newsletter-campaign"],[3877,".inline-newsletter-middle"],[3892,".inline-newsletter-module"],[1931,".inline-newsletter-subscribe"],[1852,".inline-subscription-module"],[2450,".inlineNewsletterSubscription"],[191,".inlineNewsletter__wrapper"],[1430,".inscription-newsletter"],[4003,".ipWidget-Newsletter"],[3536,".is-style-newsletter,\n.popinNewsletter-content"],[3985,".iscrizione-newsletter,\n.iscrizione_newsletter"],[602,".iscrizionenewsletter"],[3811,".item-list-newsletter-box"],[3573,".item-newsletter-article"],[128,".j-subscribe-block"],[1122,".jetpack_subscription_widget"],[497,".jq-Newsletter"],[3559,".jq_inscription_newsletter"],[1806,".js-captation-email-bottom,\n.pre-footer-subscribe"],[3601,".js-email-promo"],[2453,".js-email-widget"],[1972,".js-inline-newsletter-signup"],[2737,".js-magazineSubscriptionPopin"],[3497,".js-newsletter-sign-up-form"],[1980,".js-newsletter-subscribe"],[2624,".js-newsletter-subscription-footer"],[3165,".js-newsletter-subscription-popup"],[1063,".js-newsletter-widget"],[2345,".js-popup-newsletter"],[3842,".js-react-mailchimp-newsletter"],[3501,".js-sidebar-signup"],[3399,".js-subscription-combo-box"],[1475,".js_newsletter-btn--subscribe"],[3670,".js_newsletter-form-inline"],[1727,".js_newsletter_curation_form"],[1650,".keystone-newsletter-class"],[1124,".kl-bx-newsletter"],[3430,".klaviyo_flyout,\n.newsmail-signup"],[1108,".l-footer__newsletter"],[3003,".link-newsletter"],[3097,".listbuilder-popup-embedded"],[771,".lnk-newsletter"],[811,".m-brand-engagement"],[1089,".m-footer-newsletter"],[519,".m-form-newsletter"],[2234,".m-generic-cta--email-signup,\n.newsletter_bar"],[277,".m-newsletter-box"],[4023,".m-newsletter-signup"],[1603,".m-newsletter-toaster,\n.mc-newsletter-image"],[1044,".m-newsletter_light"],[101,".m-site-foot--newsletter,\n.newsletterlinebox"],[85,".m-subscribe-widget"],[3361,".m4p-newsletter-form"],[1245,".mail-newsletter"],[1879,".mailerlite-form"],[936,".mailing-list-signup"],[423,".mailingList--sidebar"],[520,".mailmunch-popover"],[327,".mailmunch-popover-content"],[665,".mailmunch-scrollbox"],[265,".mailpoet_form_popup_overlay"],[920,".main-footer__newsletter"],[3954,".mainbody-subscribe"],[2433,".markato-form-wrapper-tall"],[3999,".mashicon-subscribe"],[1782,".mb-newsletter,\n.md-newsletter"],[3829,".mc-newsletter-alertes"],[624,".mc-newsletter-signup"],[3578,".memo-newsletter-widget"],[1444,".mf-subscribe-widget"],[1713,".ml-webforms-popup-overlay"],[1128,".ml_signup_article"],[1546,".mo-has-email.moOptinForm"],[2397,".mo-optin-form-lightbox"],[3756,".mobile-newsletter-mobile"],[1209,".mobile-subscribeBox"],[2291,".mobile_newsletter"],[2252,".modal-email-widget"],[2407,".modal-suggest-newsletter"],[2296,".modal-wide-newsletter"],[45,".module-footer-newsletter-signup"],[2125,".module-newsletter-subscribe"],[514,".molecule-newsletter"],[3652,".mom-newsletter,\n.polaris__newsletter"],[564,".mt-subscribe"],[1127,".multi-newsletter-signup"],[3859,".mvp-post-sub-wrap"],[253,".naf-newsletter-footer"],[3964,".nav-newsletter"],[1985,".nav-newsletter-subsribe-form"],[2803,".needsclick.amped-wrapper,\n.needsclick.mcforms-wrapper"],[2396,".nesting_newsletter"],[3354,".newLetterSectionBox,\n.sidebarbox_newsletter"],[1298,".new_newsletter_subscription"],[847,".newedge-newsletter"],[3615,".newletter-main-wrapper"],[1249,".newletter-sidebar"],[1601,".newletter_container"],[1219,".newletterpopupbox"],[2609,".news-letter-widget"],[2059,".newsLetter-subscription"],[3103,".newsLetter-subscription-wrapper"],[682,".newsLetterCon"],[91,".newsLetterHolder,\n.newsletter-popups,\n.newsletter_rodape"],[1207,".newsLetterSec"],[488,".newsSignupRR"],[1850,".newsleterHome"],[2347,".newsletter--article"],[525,".newsletter--blog-container"],[2521,".newsletter--container"],[3585,".newsletter--dark,\n.newsletterContentModule"],[329,".newsletter--floatfixed"],[885,".newsletter--footer"],[2967,".newsletter--initial"],[2513,".newsletter--logged-out,\n.shortcode-inline-newsletter"],[3150,".newsletter-abo-header"],[644,".newsletter-acton-form-rightsidebar"],[1037,".newsletter-advertisement"],[3611,".newsletter-area"],[1676,".newsletter-article-bottom"],[1694,".newsletter-article-cta"],[2587,".newsletter-b2b"],[3840,".newsletter-banner,\n.newsletterWrapper"],[661,".newsletter-banner-sidebar"],[2632,".newsletter-bar"],[1530,".newsletter-bar-right"],[259,".newsletter-block-new"],[1768,".newsletter-block-wrapper"],[3011,".newsletter-bottom-article,\n.newsletter-plug"],[340,".newsletter-box-news"],[3048,".newsletter-call-to-action"],[969,".newsletter-callout,\n.newsletter_callout"],[979,".newsletter-capture"],[3117,".newsletter-card,\n.sidebar-newsletter-promo"],[2695,".newsletter-cleverreach"],[2630,".newsletter-col,\n.newsletter-pop,\n.newsletter-top"],[905,".newsletter-compact"],[2653,".newsletter-cta"],[1329,".newsletter-cta-box"],[854,".newsletter-desktop,\n.newsletter-interstitial,\n.widget_blog_subscription"],[1669,".newsletter-diverter-card"],[692,".newsletter-element__form"],[9,".newsletter-fields"],[4027,".newsletter-fixed"],[1638,".newsletter-fixed-container"],[4001,".newsletter-fly-in"],[3293,".newsletter-flyout-wrap,\n.newsletter-inline-widget"],[3187,".newsletter-foot,\n.slice-container-newsletterForm"],[78,".newsletter-footer,\n.newsletter_footer,\n.newsletter_holder"],[2536,".newsletter-footer-bar"],[2319,".newsletter-footer__content"],[3457,".newsletter-form-border"],[3272,".newsletter-frame,\n.newsletter-promo"],[3608,".newsletter-grab"],[2186,".newsletter-headline"],[1341,".newsletter-inline-flex"],[487,".newsletter-inline-newsletter-signup-wrapper"],[1794,".newsletter-inline-unit"],[2696,".newsletter-inline-wrapper"],[907,".newsletter-l"],[2958,".newsletter-l-modal"],[2460,".newsletter-layer-wrapper"],[71,".newsletter-mobile"],[1774,".newsletter-modal-background,\n.newsletter-popup-background"],[1876,".newsletter-modal-overlay"],[3305,".newsletter-modal__background,\n.newsletter-signup-module"],[2047,".newsletter-notification-box"],[2649,".newsletter-opt"],[1405,".newsletter-overlay"],[858,".newsletter-overlay-footer"],[66,".newsletter-pop-in"],[3953,".newsletter-popin"],[3488,".newsletter-popup-container"],[2019,".newsletter-popup-desktop,\n.newsletter-signup-component,\n.sidebar-subscribe-form"],[3149,".newsletter-popup-wrap"],[3949,".newsletter-popup.kadence-conversion-popup"],[29,".newsletter-promo-container"],[3768,".newsletter-pure,\n.markup.body > .subscribe-widget"],[3765,".newsletter-push"],[3744,".newsletter-recomendation-wrapper"],[1971,".newsletter-right-col"],[732,".newsletter-right-rail"],[2953,".newsletter-rightbar"],[924,".newsletter-rotator,\n.newsletter-toaster"],[3944,".newsletter-sb,\ndiv#inline-newsletter"],[1228,".newsletter-sidebar,\n.newsletter_sidebar"],[1253,".newsletter-sidebar-widget"],[2028,".newsletter-sidebar-wrapper"],[235,".newsletter-sign-up-block,\n.optin-monster-overlay"],[3905,".newsletter-sign-up-popup-mask"],[2805,".newsletter-signup-article-wrapper"],[2845,".newsletter-signup-banner"],[735,".newsletter-signup-block"],[766,".newsletter-signup-box,\ndiv.newsletter-subscription-inline"],[1803,".newsletter-signup-container"],[300,".newsletter-signup-container2"],[760,".newsletter-signup-dnd,\n.rst-newsletterbox"],[2708,".newsletter-signup-form,\n.widget_text_newsletter"],[2648,".newsletter-signup-link,\ndiv#NewsletterPromo"],[753,".newsletter-signup-mod"],[3509,".newsletter-signup-overlay,\n.newsletter_signup_overlay"],[3129,".newsletter-signup-primary"],[131,".newsletter-signup-promo,\n.newsletter_signup_promo"],[3487,".newsletter-signup-sidebar"],[746,".newsletter-signup-vue"],[2232,".newsletter-signup-wrap"],[3386,".newsletter-signup-wrapper"],[1,".newsletter-simple"],[3707,".newsletter-slideout"],[3894,".newsletter-small"],[2400,".newsletter-social-wrapper"],[2300,".newsletter-sticky-block"],[2524,".newsletter-subscribe-panel"],[2470,".newsletter-subscribe-popup-overlay,\n.react-newsletter-overlay"],[523,".newsletter-subscribe-section"],[2586,".newsletter-subscription-popup"],[3716,".newsletter-teaser"],[177,".newsletter-top-menu"],[1522,".newsletter-trigger"],[2962,".newsletter-unit"],[8,".newsletter-widget,\n.newsletter_widget"],[1273,".newsletter-widget-outer-container"],[3065,".newsletter-widget__wrapper"],[3500,".newsletter-wrapper-sidebar"],[3170,".newsletter-zone"],[3664,".newsletter1"],[188,".newsletterArticle"],[2676,".newsletterBg1"],[4029,".newsletterCallout"],[1280,".newsletterCassetto"],[1577,".newsletterCont,\n.send-us-your-news-cta"],[2629,".newsletterCta"],[183,".newsletterCtaContainer"],[2838,".newsletterFooter"],[2720,".newsletterForm-exitIntent,\n.subscribe-slide"],[1677,".newsletterHead"],[3989,".newsletterPrompt"],[3745,".newsletterSidebar,\n.wcpopupmodal-wrapper-open,\n.widget-newsletter-signup"],[3220,".newsletterSidebarContainer"],[1067,".newsletterSingle,\n.widget_newsletter_manager"],[3158,".newsletterSub"],[2304,".newsletterSubsModule"],[1641,".newsletterSubscription,\n.newsletter_area"],[1388,".newsletterWidget"],[157,".newsletter__callout"],[980,".newsletter__card"],[419,".newsletter__headline"],[1306,".newsletter__signup"],[275,".newsletter__wrapper"],[116,".newsletter_and_social"],[3763,".newsletter_background"],[2409,".newsletter_banner_inline"],[3295,".newsletter_bg"],[522,".newsletter_callout_box"],[1743,".newsletter_footer_container"],[100,".newsletter_inline"],[1466,".newsletter_promo"],[2430,".newsletter_signup_unit"],[2465,".newsletter_signup_widget"],[516,".newsletter_subscribe_banner,\n.nlsubscribe-block"],[660,".newsletter_testo"],[964,".newsletterbg"],[617,".newsletterbloc"],[2627,".newsletterbottom"],[1083,".newslettermultiple"],[1218,".newsletteronpage"],[2968,".newspack-inline-popup"],[1790,".newspack-lightbox-placement-bottom,\n.st-newsletter-widget"],[3836,".newspack-newsletter-prompt-inline"],[4,".newspack-newsletter-prompt-overlay"],[1597,".newspack-popup"],[348,".newssignup"],[757,".ng-newsletter"],[1921,".nl-signup-inline"],[1381,".nl-signup-scrollbox"],[3335,".nl-subscription-container"],[377,".nlSignUpForm"],[4085,".nlSubscribe"],[3917,".nlWidgetMain2"],[2208,".nls-subscribe"],[2342,".node-newsletter-subscribe"],[2679,".nws-cnt"],[3986,".nyp-zephr-flyout"],[3849,".o-Newsletter"],[2135,".o-footer__newsletter"],[2218,".o-footer__newsletter-signup"],[3817,".o-newsletter"],[2193,".o-widget__newsletter"],[3828,".ob-Newsletter"],[1503,".oi-dailyalerts"],[1753,".oi-dailyalerts-signup"],[3935,".optin-monster-saas-overlay"],[3529,".optin-overlay"],[879,".p-footer-subscribe"],[1760,".page--newsletter"],[3948,".page-footer-signups"],[2362,".pane-newsletter-modal"],[1812,".pane-newsletter-newsletter-subscribe"],[3640,".pane-newsletters"],[2783,".pane-subscribe-box"],[834,".pane-subscribe-callout"],[3703,".panel-newsletter-subscribe"],[319,".partial-cta-newsletter"],[1769,".partial-newsletter"],[3593,".pb-subscribe"],[3874,".pgevoke-header-row2-right-newsletters"],[3966,".piano--sidebar"],[2912,".piano-inline-promo"],[1764,".piano-newsletter"],[2024,".piano_newsletter_large_widget-2"],[973,".polaris__newsletter--form"],[3908,".pre-footer-email-signup,\n.stickyNewsletterBar"],[768,".pre-header-subscribe"],[2924,".prism-newsletter-form"],[218,".promo-newsletter-dfp"],[346,".promo-newsletter-signup-2"],[1849,".promo-newsletters"],[1144,".r-footer--newsletter"],[2941,".rc-newsletter-widget-new"],[1544,".revue-embed-form"],[1730,".rhs_subscribe_outer"],[3662,".row__newsletter"],[1877,".sailthru-signup-widget"],[140,".saxon-subscribe-block"],[3659,".sb-signup-container"],[42,".sendinblue-newsletter-mergefields"],[2101,".sendinblue-signup-subscribe-form"],[1839,".seva-overlay"],[4016,".sfba_subscribe_form"],[1579,".sfsi_subscribe_Popinner"],[270,".shortcode-newsletter"],[1343,".sib-newsletter-form"],[2306,".sidebar--newsletter,\n.sidebar__newsletter"],[2152,".sidebar-block-newsletter"],[308,".sidebar-mailchimp"],[781,".sidebar-newsticker-wrapper"],[2406,".sidebar-signup-box"],[3324,".sidebar-subscribe-box-wrapper"],[3537,".sidebar-subscribe-container"],[3181,".sidebar-tile-subscribe"],[97,".sidebar-widget--subscribe"],[2982,".sidebar-widget-newsletter"],[1644,".sidebarNewsletter"],[3402,".sidebarNewsletterAd"],[1939,".sidebarSubscription"],[2955,".sidebar__widget_subscribe"],[355,".sidebar_email_signup"],[3518,".sidebar_newsletter_sign_up,\n.widget_mailpoet_form"],[3631,".sidebar_subscribe"],[3634,".sidebar_subscriber_body"],[444,".signup-bar_wrapper"],[705,".signup-form--header"],[1525,".signup-newsletter-sidebar"],[3521,".simplenews_custom-newsletter"],[3621,".single-newsletter-signup"],[1252,".single-sidebar--newsletter"],[1791,".site-footer-newsletter"],[1741,".site-footer__newsletter"],[474,".site-footer__section-newsletter"],[395,".skinny-sign-up"],[1837,".skinny-signup"],[350,".slide-in--newsletter"],[216,".slidedown-newsletter"],[3569,".slider_newsletter-container"],[3637,".slideup-newsletter-optin"],[3802,".sm_newsletter"],[118,".smart-ajax-subscribe-form"],[2349,".smile-prompt-frame-container"],[1647,".sml_subscribe_widget"],[123,".ssb-subscribe-box"],[3769,".stickybar--newsletter"],[1148,".subscribe-article-bottom"],[2089,".subscribe-box-wide"],[2594,".subscribe-float"],[3362,".subscribe-header-panel"],[1235,".subscribe-newsletters-cta"],[3367,".subscribe-popup-fade"],[2372,".subscribe-popup-overlay"],[2984,".subscribe-share"],[3897,".subscribe-widget-container"],[1289,".subscribe-widget-sidebar"],[662,".subscribeShortcodeContainer"],[1637,".subscribeWidget"],[1878,".subscribeWidgetContainer"],[2771,".subscribe_cont"],[2320,".subscribe_popup1"],[2272,".subscription-box-cntr"],[1017,".subscription-cta-widget"],[3633,".subscription-form-container"],[2419,".subscription-newsletter-button"],[4063,".subscription-popup-overlay"],[670,".subscription-promo"],[3123,".subscription-toaster"],[219,".subscription-unit"],[2324,".suc-newsletter"],[18,".t-newsletter"],[2530,".teaser-newsletter"],[1672,".tgc-newsletter-signup"],[568,".thb-newsletter-form"],[1734,".thim-newlleter-homepage"],[242,".tm-editoral-subscription"],[1402,".tnp-subscription"],[257,".tnp-subscription-minimal"],[3691,".tpd-newsletters-form"],[747,".ts-newslatter"],[3657,".tsq_sailthru_newsletter_widget"],[1182,".tt-newsletter-subscribe-footer"],[3636,".ttgFooterNewsletterFlyInWrapper"],[3207,".tve-leads-widget"],[3310,".ue-c-newsletter-widget"],[4053,".vc-email-subscribe__wrapper"],[1695,".vc_newsletters_subscription"],[961,".vspl__section--newsletter"],[3259,".wcpopupmodal-open,\n.widget_newsletter-pack"],[3210,".wide-newsletter"],[267,".wideNewsletterWrap"],[3327,".widget--subscribe-inline"],[1809,".widget-embed.newsletter"],[3270,".widget-newsletter-fter"],[3121,".widget-newsletter-newsletter"],[832,".widget-newsletter-sign-up"],[2848,".widget-ngs-subscribe"],[1619,".widget-subscribe"],[1394,".widget-tsq_sailthru_newsletter_widget"],[3172,".widget__subscribe"],[1918,".widget_bs-newsletter-mailchimp"],[477,".widget_bs-subscribe-newsletter"],[1456,".widget_email-subscribers-form"],[2652,".widget_email_subscribe"],[3713,".widget_home_newsletter"],[3814,".widget_jnews_module_element_ads"],[2358,".widget_jtsvnewslettersignupwidget"],[1190,".widget_mailerlite_widget"],[2370,".widget_mailster_signup"],[3952,".widget_mc4wp_form_widget"],[3848,".widget_mymail_signup"],[993,".widget_newsletter_sidebar"],[94,".widget_newsletter_widget"],[1101,".widget_newsletterwidget"],[1759,".widget_newsletterwidgetminimal"],[196,".widget_nls_form_widget"],[1596,".widget_ns_mailchimp"],[1907,".widget_sailthru_signup_widget"],[3541,".widget_signupwidget"],[398,".widget_subscribe-form"],[1519,".widget_subscribe_box,\n.adblock-whitelist-messaging__wrapper"],[1135,".widget_subscribe_widget"],[1468,".widget_subscriber_widget"],[989,".wp-block-ione-newsletter-sign-up"],[1648,".wp-block-newsletter"],[684,".wp-block-signup-new"],[436,".wp-block-xwp-newsletter-subscription"],[1827,".wp-nwletter-popup"],[476,".wp_email_capture_widget"],[3436,".wpdev-newsletter-signup"],[3365,".wpdiscuz-subscribe-bar"],[271,".wrap-newsletter"],[3759,".wrapper-button-newsletter"],[2339,".wrapper_suscribe_home"],[1260,".yel-email-popup"],[2285,".yel-popup-main-wrapper"],[33,".yt-mailchimp-subscription-form-widget"],[1347,".z-newsletter-signup-bottom"],[3607,"div.aside-newsletter"],[3563,"div.aside-newsletter-box"],[1705,"div.bs-mailchimp-newsletter"],[3761,"div.c-newsletter-article"],[244,"div.newsletter-sign-up-popup"],[2111,"div.newsletter-subscribe-widget"],[888,"div.newsletter-subscription-module"],[3804,".gh-footer-signup"],[2173,".gh-outer.gh-cta"],[2502,".gh-portal-triggerbtn-iframe"],[513,".gh-post-page-cta"],[2332,".outpost-pub-container"],[1934,"#ctl00_NewsletterFooter_UpdateForm"],[3469,".pc-reset > ._container_cjrxc_1"],[168,".single-post-container > .subscribe-footer"],[213,".cpcta-flyin"],[2608,"#nlgate"],[2091,"#nlgate-overlay-0"],[3111,".newsletter-widget__new-story-page"],[1665,".inset-x-0[x-data=\"adblockBanner()\"]"],[1524,"#steadyAdblockContainer"],[3418,"body div#notificationPopup.notificationPopupBlock"]];
const genericExceptionSieve = [706,3365,2947,3248,2506,2891,3826,121,3528];
const genericExceptionMap = [["onepercentclub.co.uk",".et_pb_newsletter"],["doctorofcredit.com",".wpdiscuz-subscribe-bar"],["cyanlabs.net","ins.adsbygoogle[data-ad-slot]\nins.adsbygoogle[data-ad-client]"],["telewebgram.com","ins.adsbygoogle[data-ad-slot]\nins.adsbygoogle[data-ad-client]"],["fmovies.*",".fa-rss"],["puhekupla.com",".googlead"],["dhd24.com",".adunit"],["goodreads.com",".Overlay--floating:has(> div.Overlay__window > div.Overlay__content > div.LoginInterstitial)"],["swagbucks.com",".ad_warn\n#topAd"]];

if ( genericSelectorMap ) {
    const map = self.genericSelectorMap =
        self.genericSelectorMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericSelectorMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before},\n${entry[1]}`);
            }
        }
    } else {
        self.genericSelectorMap = new Map(genericSelectorMap);
    }
    genericSelectorMap.length = 0;
}

if ( genericExceptionSieve ) {
    const hashes = self.genericExceptionSieve =
        self.genericExceptionSieve || new Set();
    if ( hashes.size !== 0 ) {
        for ( const hash of genericExceptionSieve ) {
            hashes.add(hash);
        }
    } else {
        self.genericExceptionSieve = new Set(genericExceptionSieve);
    }
    genericExceptionSieve.length = 0;
}

if ( genericExceptionMap ) {
    const map = self.genericExceptionMap =
        self.genericExceptionMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericExceptionMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before}\n${entry[1]}`);
            }
        }
    } else {
        self.genericExceptionMap = new Map(genericExceptionMap);
    }
    genericExceptionMap.length = 0;
}

/******************************************************************************/

})();

/******************************************************************************/
